/**********************************************************************
 * Perform calculations for resizing elements in the screen.
 *
 * Created : 2020/01/20 FSI
 * Modified:
 *
 */

// Use jQuery and jQuery UI
/*
 * jQuery JavaScript Library
 * https://jquery.com/
 * Copyright JS Foundation and other contributors
 * Released under the MIT license
 * https://jquery.org/license
 */
/*
 * jQuery UI Widget
 * http://jqueryui.com
 * Copyright jQuery Foundation and other contributors
 * Released under the MIT license.
 * http://jquery.org/license
 */

var BORDER_WIDTH = 2; // border width 2px
var H_PRIMSTAT = 42; // primstat Height
var waitDispIHMI = 0; // wait dispIHMIProc count
var TPKEY_HEIGHT = 55; // tpkeys height

/*
 * Object for calculating the height and width of an element.
 *
 *   modS  =  #treemod (width)
 *   keyV  =  keys_vis (true or false)
 *   keyO  =  is_key_open (true or false)
 *   vertD =  is_vtcl_disp (true or false)
 *   treeL =  tree menu was locked  (true or false)
 *   ihmiM = display ihmi editor
 *
 * Create css by adding a string to the default settings.
 * setDispCSS() change to a string that can actually be written to css.
 */
var IRP_RESIZE_OBJ = {
  primstat: { // #primstat
    h: function () { return ""; },
    w: function () { return "100% - " + BORDER_WIDTH + "px"; },
  },
  mainfunc_area: { // #mainfunc_area
    h: function () { return ""; },
    w: function (modS, keyV, keyO, vertD, treeL) {
      return "100%" + ((treeL) ? " - " + modS + "px" : "") + (((keyO) && (!vertD)) ? " - " + top.W_KEY_SHEET  + "px" : "");
    }
  },
  mainfrm: { // #mainfrm
    h: function (modS, keyV, keyO, vertD, treeL, pnlL) {
      if (top.g_startmd == CTRLSTART) {
        return "" + ((vertD) ? (top.h_mainfrm - $("#funckeys").outerHeight() - top.H_KEY_SHEET - $("#tpkeys").outerHeight() + "px")
                            : (top.h_mainfrm - $("#funckeys").outerHeight() - $("#tpkeys").outerHeight() + "px"));
      }
      var mfrH = ((top.h_mainfrm - top.h_keys < 0) ? 0 : top.h_mainfrm - top.h_keys);
      return "" + ((((vertD) && (keyO)) || (pnlL)) ? mfrH + "px" : "");
    },
    w: function () { return "100%"; }
  },
  container: { // #container
    h: function (modS, keyV, keyO, vertD, treeL, pnlL) {
      return "" + (((keyV) && (vertD) && ((keyO) || (pnlL))) ? "" : "100%"); // Not used
    },
    w: function () { return "100%"; }
  },
  prim: { // #prim
    h: function () { return ""; },
    w: function () { return "100% - " + BORDER_WIDTH + "px"; },
  },
  funckeys: { // #funckeys
    h: function (modS, keyV, keyO, vertD, treeL, pnlL) {
      return "" + (((keyV) && (vertD) && ((keyO) || (pnlL))) ? "100%" : ""); // Not used
    },
    w: function () { return "100%"; }
  },
  tpkeyssheet: { // #tpkeyssheet
    h: function (modS, keyV, keyO, vertD, treeL, pnlL) {
      return "" + ((keyO) ? ((vertD) ? ((document.getElementById('funckeys').style.display != "none") ? top.H_KEY_SHEET + parseInt($("#funckeys").css("height")) : top.H_KEY_SHEET) + "px" : top.h_keysheet + "px") : "");
    },
    w: function (modS, keyV, keyO, vertD, treeL, pnlL) {
      return "" + ((!keyO) ? "100%" : ((vertD) ? ((treeL) ? " - " + modS + "px" : "100%") : top.W_KEY_SHEET + "px"));
    }
  },
  tpkeys: { // #tpkeys
    h: function () { return ""; },
    w: function (modS, keyV, keyO, vertD, treeL, pnlL) {
      return "100%" + ((treeL) ? " - " + modS + "px" : "");
    }
  },
  home: { // #home
    h: function (modS, keyV, keyO, vertD, treeL, pnlL) {
      var homeH = ($(window).height() - 122) - ((pnlL) ? $("#dummypnlarea").outerHeight() : 0);
      return ((homeH < 0) ? 0 : homeH) + "px";
    },
    w: function (modS, keyV, keyO, vertD, treeL, pnlL) {
      return "100%" + ((treeL) ? " - 242px" : " - 4px");
    }
  },
  dummypnlarea: { // #dummypnlarea
    h: function (modS, keyV, keyO, vertD, treeL, pnlL) {
      var pnlH = $("#pnlarea").outerHeight(); // panel height
      var mfrH = $(window).height() - ((keyV) ? 155 : 155 - $("#funckeys").outerHeight()) - pnlH; // 155 => statbar height + mainfunc_area minimum height
      var dmyH = ((mfrH < TPKEY_HEIGHT) ? ((pnlH - (TPKEY_HEIGHT - mfrH) < 0) ? 0 : pnlH - (TPKEY_HEIGHT - mfrH)) : pnlH);
      return ((pnlL) ? dmyH + "px" : ""); // The above is the calculation to display tpkeys on the screen as much as possible
    },
    w: function (modS, keyV, keyO, vertD, treeL, pnlL) {
      return "" + ((!pnlL) ? "100%" : ((treeL) ? " - " + modS + "px" : "100%"));
    }
  }
};

// Object to get settings from element name
var IRP_RESIZE_ARR = {
  "primstat": IRP_RESIZE_OBJ["primstat"],
  "mainfunc_area": IRP_RESIZE_OBJ["mainfunc_area"],
  "mainfrm": IRP_RESIZE_OBJ["mainfrm"],
  "container": IRP_RESIZE_OBJ["container"],
  "prim": IRP_RESIZE_OBJ["prim"],
  "funckeys": IRP_RESIZE_OBJ["funckeys"],
  "tpkeyssheet": IRP_RESIZE_OBJ["tpkeyssheet"],
  "tpkeys": IRP_RESIZE_OBJ["tpkeys"],
  "home": IRP_RESIZE_OBJ["home"],
  "dummypnlarea": IRP_RESIZE_OBJ["dummypnlarea"]
};

// Get css string according to mode
function resizeAccCond(elem, side) {
  var cssStr = "";
  var obj    = searchConfObj(elem, side);
  var modS   = parent.$('#treemod', parent.document).outerWidth();
  var keyV   = top.keys_vis; // keys visible
  var keyO   = top.is_key_open; // key open
  var vertD  = top.is_vtcl_disp; // vertical display
  var treeL  = top.g_startmd == CTRLSTART ? false : (parent.$("#treebtn").css('display') == 'none'); // treemenu lock
  var pnlL   = (top.is_lock_pnl && ($("#pnlarea").css('display') == 'block')); // panel lock

  if (typeof obj != 'function') {
    return ""; // Returns an empty string if setting failed
  }
  cssStr = obj(modS, keyV, keyO, vertD, treeL, pnlL);
  return cssStr;
}

function searchConfObj(elem, side) {
  var objName =
    (((elem.slice(0, 1) == ".") ||
      (elem.slice(0, 1) == "#")) ? elem.slice(1) : elem);
  var objSide = side.slice(0, 1);
  var obj = IRP_RESIZE_ARR[objName][objSide];
  return obj;
}

// calc statbar size (call common.hdr)
function calcStatTab(width) {
  var returnSize = 0;
  if (!isDispCRXStat()) {
    returnSize = width - (parent.$("#treebtn").outerWidth() + parent.$("#leds").outerWidth());
  } else {
    returnSize = width - ($("#treebtn").outerWidth()) - BORDER_WIDTH;
  }
  return returnSize;
}

function isDispCRXStat() {
  var crxStatDisp = false;
  switch (top.getUICfg()) {
    case top.UI_CFG.DBG_TAB:
      break;
    case top.UI_CFG.TAB:
    case top.UI_CFG.CRX:
      crxStatDisp = (!top.is_key_open);
      break;
    case top.UI_CFG.DBG_CRX:
      crxStatDisp = true;
      break;
    default:
      break;
  }
  return crxStatDisp;
}

// calc statbar size (call common.hdr)
function calcFkeys(height) {
  return (!(top.keys_vis) ? 0 : height);
}

// setting display vertical or horizontal (call common.hdr)
function setVHDisp() {
  var h_window = parent.$(window).height();
  var h_statbar = $("#statbar").css("display") == "none" ? 0 : parent.$('#statbar', parent.document).height();
  var h_tpkeys = parent.$('#tpkeys', parent.document).height();
  var w_treemod = parent.$('#treemod', parent.document).outerWidth();

  if (top.is_vtcl_disp) {
    // for vertical display
    setVtclDisp(h_window, h_statbar, h_tpkeys, w_treemod);
  } else {
    // for horizontal display
    setHrznDisp(h_window, h_statbar, h_tpkeys, w_treemod);
  }

  setDispCSS("#tpkeyssheet", "width");
  setDispCSS("#tpkeyssheet", "height");
  setDispCSS("#dummypnlarea", "width");
  setDispCSS("#dummypnlarea", "height");
  updateHKeys(); // update h_keys
  setDispCSS("#mainfunc_area", "width");
  setDispCSS("#mainfrm", "height");
}

// If css starts from + or-, add "100%" at the beginning.
// If + or-is included in css, enclose it in "calc ()".
// When the parent element is specified, search for elem from the content of the parent element and set css.
function setDispCSS(elem, side, parentElem) {
  var newCss = resizeAccCond(elem, side);
  if (newCss != "") {
    var trimStr = newCss.trim();
    newCss =
      (((trimStr.indexOf("-") == 0) || (trimStr.indexOf("+") == 0)) ? "calc(100%" + newCss + ")" :
        (((trimStr.indexOf("-") > 0) || (trimStr.indexOf("+") > 0)) ? "calc(" + newCss + ")" : newCss));

    if (typeof parentElem != 'undefined') {
      parent.$(parentElem).contents().find(elem).css(side, newCss);

    } else {
      parent.$(elem).css(side, newCss);
      resizeCtrlStrtPrim(elem, side, newCss);
    }
  }
}
// for control start
function resizeCtrlStrtPrim(elem, side, newCss) {
  if ((elem == "#mainfrm") && (side == "height") &&
    (top.g_startmd == CTRLSTART) && (parent.$(elem).contents().find("#primstat").length > 0) &&
    (navigator.userAgent.toLowerCase().indexOf("ipad") > 0)) {
    // fix prim and container for iPad bug
    var h_prim_cont = parseInt(newCss) - parent.$(elem).contents().find("#primstat")[0].offsetHeight;
    parent.$(elem).contents().find("#prim").css(side, h_prim_cont);
    parent.$(elem).contents().find("#container").css(side, h_prim_cont);
  } else if ((elem == "#mainfrm") && (side == "height") && (top.g_startmd == CTRLSTART)) {
    var h_prim_cont = parseInt(newCss) - parent.$(elem).contents().find("#primstat").outerHeight() - 2 + "px";
    parent.$(elem).contents().find("#prim").css(side, h_prim_cont);
    parent.$(elem).contents().find("#container").css(side, h_prim_cont);
  } else if ((elem == '#mainfunc_area') && ($('#almArea').length > 0)) {
    top.resizeAlm();
  }
}

// calc tree (and key sheet) width
function setTreeWidth() {
  var newSize = 0;
  var modS    = parent.$('#treemod', parent.document).outerWidth();
  newSize += ((parent.$("#treebtn").css('display') == 'none') ? modS : 0);
  newSize += (((top.is_key_open) && (!top.is_vtcl_disp)) ? top.W_KEY_SHEET : 0);
  return newSize;
}

function setMultiWinCSS(id) {
  var setFrmCSS = function (stat, frm) {
    // primstat,dualstat,thirdstat css setting
    top.mainfrm.$(stat).css({
      "margin": "0px",
      "vertical-align": "bottom",
      "border-top": "none",
      "border-left": "none",
      "width": "calc(100% - " + BORDER_WIDTH + "px)"
    });
    // prim,dual,third css setting
    top.mainfrm.$(frm).css({
      "margin": "0px",
      "vertical-align": "bottom",
      "width": "calc(100% - " + BORDER_WIDTH + "px)",
      "border-top": "none",
      "border-left": "none"
    });
  }
  switch (id) {
    case "wholemod":
      setFrmCSS("#primstat", "#prim");
      break;
    case "doublmod":
    case "doubhmod":
      setFrmCSS("#primstat", "#prim");
      setFrmCSS("#dualstat", "#dual");
      break;
    case "triplmod":
    case "triphmod":
      setFrmCSS("#primstat", "#prim");
      setFrmCSS("#dualstat", "#dual");
      setFrmCSS("#thirdstat", "#third");
      break;
  }
}

// h_keys update
function updateHKeys() {
  var h_tpkeys = parent.$('#tpkeys').outerHeight();
  if ((top.is_lock_pnl) && ($("#pnlarea").css('display') == 'block')) {
    top.h_keys = $("#pnlarea").outerHeight() + h_tpkeys;
  }else if (top.is_vtcl_disp) {
    if (top.is_key_open) {
      // keysheet open
      top.h_keys = top.H_KEY_SHEET + h_tpkeys;
    } else {
      // keysheet close
      top.h_keys = h_tpkeys;
    }
  } else {
    top.h_keys = calcFkeys(h_tpkeys);
  }
}

// count multi window
function countMultiIFrame() {
  var returnCount = 1;
  var mainFrmObj = top.mainfrm.frameElement.contentDocument;
  if (typeof mainFrmObj == 'undefined') {
    return returnCount;
  }

  var iFrameDual  = $(mainFrmObj).find('#dual');
  var iFrameThird = $(mainFrmObj).find('#third');
  if (iFrameDual.length > 0) {
    returnCount++;
  }
  if (iFrameThird.length > 0) {
    returnCount++;
  }
  return returnCount;
}

// return active frame id
function getMyFrameId() {
  var frmId = ["prim", "dual", "third"];
  var rootFrame = top.mainfrm;
  var returnFrmId = "prim";
  for (var i = 0; i < countMultiIFrame(); i++) {
    if (rootFrame.frameElement.contentDocument == null) {
      break;
    }
    var targetFrame = rootFrame.frameElement.contentDocument.getElementById(frmId[i] + "stat");
    if (targetFrame == null || targetFrame.contentDocument.getElementsByTagName("body").length == 0) {
      setTimeout(function () {
        getMyFrameId()
      }, 500);
    } else {
      var targetTag = targetFrame.contentDocument.getElementsByTagName("body");
      var bgColor = window.getComputedStyle(targetTag[0]).getPropertyValue('background-color');
      if (bgColor == "rgb(58, 59, 59)") {
        returnFrmId = frmId[i];
        break;
      }
    }
  }
  return returnFrmId;
}

// collision avoidance by binding (call rpcmc_tpextreq)
function setchangeStat() {
  if ((top.getUICfg() == top.UI_CFG.TAB) || (top.getUICfg() == top.UI_CFG.CRX)) {
    var ifr = top.document.getElementById('statbar');
    ifr.onload = function () {
      setTimeout(function () {
        if (!top.is_key_open) {
          top.pnlarea.dispPnlLock(true);
        } // Redisplay panel lock icon
        top.wait_key_open = false;
      }, 1500);
      this.onload = null;
    };
  }
}

function unloadIhmiDmm(windowId) {
  setTimeout(function () {
    if(top.treemod.primScreenId == top.IHMI_EDITOR_ADDRESS) { // Do nothing when unloading while the editor is selected.
      getCurScrn();
    }else if(windowId == "prim") { // for hide iHMIEditor
      dispIHMIproc(false, null);
    }
  }, 0);
}

// Change the color so that the key sheet display button cannot be pressed when ihmi is displayed.
function dispIHMIproc(isHome, query) {
  top.irprogapi.dispPauseCautionPopup(top.home.window);
  if ((top.tpkeys.document.getElementById('tpkey_btn_parent') == null) ||
      (top.home.crxeditor_active == undefined)) {

    if (waitDispIHMI < 50) { // If the reading is not completed after 50 attempts, the trial ends.
      setTimeout(function () { dispIHMIproc(isHome, query); }, 100);
      waitDispIHMI++;
      return;
    }
  }
  waitDispIHMI = 0;

  var homefrm = parent.$("#home");
  var mainfrm = top.document.getElementById('mainfrm');
  var funckey = top.document.getElementById('funckeys');

  if ((!isHome) && (homefrm.css("z-index") == "1")) { // Display main frame.
    // Make the main non-transparent.
    mainfrm.style.opacity = "1";
    funckey.style.opacity = "1";
    homefrm.css({ "z-index": "-1", "opacity": "0" });

    // Notify ihmieditor_main to hide.
    setTimeout(function () { top.home.crxeditor_active(0, null); }, 0);

  } else if ((isHome) && (homefrm.css("z-index") != "1")) { // Display home frame.
    // Notify ihmieditor_main to display.
    setTimeout(function () { top.home.crxeditor_active(1, query); }, 0);

    // Place Home in front and hide key button.
    homefrm.css({ "opacity": "1", "z-index": "1" });
    // Make the main transparent.
    mainfrm.style.opacity = "0";
    funckey.style.opacity = "0";

    // For example, jumping iHMI screen cause server request.
    top.treemod.primScreenId = top.IHMI_EDITOR_ADDRESS.replace(/&/g, '^');
    top.treemod.setUrlList(top.treemod.primScreenId, true);
    top.treemod.update_tree(top.UT_IHMI);
  }
  if ((top.getUICfg() == top.UI_CFG.DBG_CRX) &&
      (top.$('#almArea').length != 0)) {
    top.resizeAlm();
  }
}

// ihmi editor url check
function checkIHMIUrl(url) {
  var ihmiURL = top.IHMI_EDITOR_ADDRESS;
  var ihmiURLNum = ((url.indexOf('menupage,') > -1) ? // ihmi editor url check
    ihmiURL.substring(ihmiURL.indexOf('menupage,'), top.IHMI_EDITOR_ADDRESS.length) : 'ihmieditor');

  return ihmiURLNum;
}

// get current screen ID (Before)
function getCurScrn() {
  rpcmc_getVar(top.SYSNAME_C, '$TP_CURSCRN[1].$SP_ID', getCurScrnCB);
}
// get current screen ID (After)
function getCurScrnCB(progname, varname, typecode, value) {
  rpcmc_getVar(top.SYSNAME_C, '$TP_CURSCRN[1].$SCRN_ID', unloadIHMIProc, value);
}
function unloadIHMIProc(progname, varname, typecode, afvalue, bfvalue) {
  if ((typeof top.mainfrm.prim == 'undefined') ||
    (top.mainfrm.prim.location.href.indexOf('/blank.htm') > -1) ||
    (top.mainfrm.prim.location.href.indexOf('about:blank') > -1)) { // For reloading.
    setTimeout(function () {
      unloadIHMIProc(progname, varname, typecode, afvalue, bfvalue);
    }, 50);
  } else if (top.mainfrm.prim.location.href.indexOf('/ihmieditor_dummy.htm') > -1) { // For reloaded with Editor selected.
    // No action.
  } else { // For example, jumping USER screen cause message inst.
    dispIHMIproc(false, null); // for hide iHMIEditor
    if ((Number(bfvalue) == 37) && (Number(afvalue) == 1)) { // For jumping USER screen cause message inst.
      top.treemod.waitLoadStatbar('dispBackBtn');
    }
  }
}

// Screen settings for displaying the key sheet
function initKeysheet() {
  var tpkeysheetCont = parent.$("#tpkeyssheet").contents();
  var isVHSwitch = false;
  setDispCSS("#mainfrm", "height");
  if (top.is_key_open) {
    // Show keysheet
    setDispCSS("#mainfunc_area", "width");
    if (top.is_vtcl_disp) {
      // for vertical display
      if (tpkeysheetCont.find('#R-shift_parent').css("display") == "none") isVHSwitch = true;
      // Right shiftkey show
      tpkeysheetCont.find('#R-shift_parent').css({ "display": "block" });
      // LR switch button hide
      tpkeysheetCont.find('.lr_switch').css({ "display": "none" });

      // shiftkey add class
      tpkeysheetCont.find('#L-shift_parent').removeClass('l_shift_hrzn');
      tpkeysheetCont.find('#L-shift_parent').addClass('l_shift_vtcl');
      // keysheet area add class
      tpkeysheetCont.find('#tpkeysheet_area').removeClass('keysheet_area_hrzn');
      tpkeysheetCont.find('#tpkeysheet_area').addClass('keysheet_area_vtcl');
      if (top.keys_vis) {
        tpkeysheetCont.find('#keysheet_box').css({ "height": "475px" });
      } else {
        tpkeysheetCont.find('#keysheet_box').css({ "height": "" });
      }
    } else {
      // for horizontal display
      if (tpkeysheetCont.find('#R-shift_parent').css("display") != "none") isVHSwitch = true;
      // button size
      var h_window = $(window).height();
      var h_statbar = $('#statbar', parent.document).height(); // statusbar height
      var h_tpkeys = $('#tpkeys', parent.document).height(); // tpkeys height
      var h_tpkeysheet = tpkeysheetCont.find('.tpkey_sheet').height(); // keysheet height
      var h_shift_switch = h_window - h_statbar - h_tpkeys - h_tpkeysheet // shift and LR switch button  height
      tpkeysheetCont.find('.l_shift_hrzn').css({ "height": h_shift_switch });

      // Right shiftkey hide
      tpkeysheetCont.find('#R-shift_parent').css({ "display": "none" });

      // shiftkey add class
      tpkeysheetCont.find('#L-shift_parent').removeClass('l_shift_vtcl');
      tpkeysheetCont.find('#L-shift_parent').addClass('l_shift_hrzn');

      // LR switch button show
      setLRSwitch();

      // keysheet area add class
      tpkeysheetCont.find('#tpkeysheet_area').removeClass('keysheet_area_vtcl');
      tpkeysheetCont.find('#tpkeysheet_area').addClass('keysheet_area_hrzn');
      tpkeysheetCont.find('#keysheet_box').css({ "height": "" });
    }
    $('#tpkeyssheet').show();
    if (isVHSwitch && document.getElementById("tpkeyssheet").contentWindow.g_releaseAllKeys != undefined) {
      document.getElementById("tpkeyssheet").contentWindow.g_releaseAllKeys();
    }
  }
  setDispCSS("#primstat", "width", "#mainfrm");
  resizeHomeProc();
  if (top.g_startmd == CTRLSTART) {
    $('#tpkeys').hide();
  } else {
    $('#tpkeys').show();
  }
  if (top.keys_vis) {
    $('#funckeys').show();
    if (top.isTabTP()) {
      try {
        if (Number(android.ApiTabTPVersion()) == 1.06) {
          android.ApiEnableResize(false);
        }
      } catch (e) { }
    }
  } else {
    $('#funckeys').hide();
    if (top.isTabTP()) {
      try {
        if (Number(android.ApiTabTPVersion()) == 1.06) {
          android.ApiEnableResize(true);
        }
      } catch (e) { }
    }
  }
}

// Mainframe size settings for vertical display
function setVtclDisp(h_window, h_statbar, h_tpkeys, w_treemod) {
  parent.$('#tpkeyssheet').css({
    "float": '',
    "position": '',
    "right": '',
    "display": ''
  });
  parent.$('#mainfunc_area', parent.document).css({
    "float": '',
    "position": '',
    "right": '',
  });
}

// Mainframe size settings for horizontal display
function setHrznDisp(h_window, h_statbar, h_tpkeys, w_treemod) {

  // key sheet open
  if (is_key_open) {
    if ($('#treebtn', parent.document).css('display') == 'none') {
      var changeElem = ((top.keysheetLR.main == "right") ?
        "#mainfunc_area" : "#tpkeyssheet");

      $(changeElem, parent.document).css({
        "position": 'relative',
        "right": w_treemod,
      });

    } else {

      $('#mainfunc_area', parent.document).css({
        "position": '',
        "right": '',
      });
      $('#tpkeyssheet', parent.document).css({
        "position": '',
        "right": '',
      });

    }
    if (top.g_startmd == CTRLSTART) {
      top.h_keysheet = h_window - h_statbar - 2;
    } else {
      top.h_keysheet = h_window - h_statbar - h_tpkeys - 2;
    }

    // setting
    $("#mainfunc_area").css({
      "float": top.keysheetLR.main,
    });
    $("#tpkeyssheet").css({
      "display": '',
      "float": top.keysheetLR.keysheet,
    });
  } else {
    // key sheet close
    $('#tpkeyssheet', parent.document).css({ "display": "none", "float": '', "position": '', "right": '' });

  }
  if (navigator.userAgent.indexOf("iPad") > 0) {
    setDispCSS("#container", "width", "#mainfrm");
  }
}
// statbar size setting
function setStatbarCSS() {
  if (isDispCRXStat()) {
    $('#statbar').css({
      'border-bottom': 'solid 2px black',
      'border-right': 'solid 2px black',
      'height': '63px'
    });
  } else {
    $('#statbar').css({
      'border-bottom': '',
      'border-right': '',
      'height': '65px'
    });
    $('#treebtn').css('border-bottom', '');
  }
}

// Called from common.hdr. calc mainframe height.
function getCalcMainfrm(){
  var h_led = top.$("#leds").outerHeight();
  var h_return = top.$(window).height();
  return h_return - h_led;
}

// // add div to display title for homestat
function addHomeReloadProc() {
  top.$("#mainfrm").css({ "background": "rgb(60, 60, 60)" });
  top.jQuery.dictlis.bind('SetLangEvent', null, reloadIHMIProc);
}

function reloadIHMIProc() {
  top.home.location.reload(true);
  top.pnlarea.location.reload(true);
  top.tpkeyssheet.location.reload(true);
  if($("#irpreload") != undefined) top.irpreload.location.reload(true);
  top.irprogapi.setCurrentLanguage(langSetAfterProc);
  if (top.is_lock_pnl) {
    top.pnlarea.switchPnlLock(false, true);
  }
  if ($("#pnlarea").outerHeight() > 0) {
    $("#pnlarea").css("display", "none");
  }
}

function langSetAfterProc() {
  top.setAlmArea(true);
}

function resizeHomeProc() {
  var treeL = (parent.$("#treebtn").css('display') == 'none'); // treemenu lock
  var frmTop = ((treeL) ? "0px" : "65px");

  setDispCSS("#home", "width");
  setDispCSS("#home", "height");
  $('#home', parent.document).css({ "top": frmTop });

  // Undo tpkeys position(from ipkey.stm)
  parent.$('#tpkeys', parent.document).css({ "position": "relative", "bottom": "" });
  if (typeof top.pnlarea.resizePnlProc === 'function') {
    top.pnlarea.resizePnlProc();
  }
}