var treebtn_w;
var statbar_w;

// for change menu base or custom
var currentMenu = 1;
var MENU_BASE = 0;
var MENU_CUSTOM = 1;
var TYPE_BASE_TREE = 'uiftree_menuonly';
var TYPE_CUSTOM_TREE = 'uiftree'; //'uiftree_menuonly';//'uiftree_menu';

//FSI 20190801 Tree menu button function
$(function () {
  $('#treeHomeBtn').on('click touchend', function treeHomeProc(event) {
    if (event != undefined &&
      event.type.indexOf('touch') >= 0) {
      event.preventDefault();
    }

    cancel_treeClose();
    if (top.isExistCB()) {
      try {
        top.screenTrans[top.getMyFrameId()].transProc = treeHomeProc; //Processing after the instruction from the prim.
        top.screenTrans[top.getMyFrameId()].cb();
      } catch (e) {
        top.screenTrans[top.getMyFrameId()].cb = undefined;
        var props = { value: "" };
        props.value = top.IHMI_EDITOR_ADDRESS;
        top.treemod.nodeOnClick(null, props);
        top.treemod.update_tree_url(top.IHMI_EDITOR_ADDRESS);
        console.log(e);
        return false;
      }
    } else {
      var props = { value: "" };
      props.value = top.IHMI_EDITOR_ADDRESS;
      top.treemod.nodeOnClick(null, props);
      top.treemod.update_tree_url(top.IHMI_EDITOR_ADDRESS);
      return false;
    }
  });

  $('#treeLockBtn').on('click touchend', function (event) {
    if(event.type.indexOf('touch') >= 0){
      event.preventDefault();
    }
    change_treeMenuLock();
    return false;
  });

  $('#treeCstmBtn').on('click touchend', function treeCstmProc(event) {
    if (event != undefined &&
      event.type.indexOf('touch') >= 0) {
      event.preventDefault();
    }

    cancel_treeClose();
    if (top.isExistCB()) {
      top.screenTrans[top.getMyFrameId()].transProc = treeCstmProc; //Processing after the instruction from the prim.
      top.screenTrans[top.getMyFrameId()].cb();
    } else {
      var props = { value: "" };
      props.value = top.MENU_CSTM_ADDRESS;
      top.treemod.nodeOnClick(null, props);
      top.treemod.update_tree_url(top.MENU_CSTM_ADDRESS);
      return false;
    }
  });

  $('#treeChgBtn').on('click touchend', function (event) {
    if(event.type.indexOf('touch') >= 0){
      event.preventDefault();
    }
    // change tree menu
    var menuType = ((currentMenu == MENU_CUSTOM) ? MENU_BASE : MENU_CUSTOM);
    tree_changeMenu(menuType);

    top.treemod.focus();
    return false;
  });

  // 2020/3/18 Fsi
  $('#logoutBtn').on('click touchend', function (event) {
    if(event.type.indexOf('touch') >= 0){
      event.preventDefault();
    }
    var dlgMsg = top.irpDlgRes['logoutMsg'];
    if (top.isTabTP()) {
      dlgMsg = top.irpDlgRes['tpLogoutMsg'];
    }
    top.openCmpConfirm('logoutDlg', top.window, 'logoutDlg', dlgMsg,
                      { btnData : top.irpDlgBtnYN, btn1Cb: top.preDoLogout });
    return false;
  });
});

// If it click the tree menu buttons and the tree menu is about to close when before click function, cancel it.
function cancel_treeClose() {
  // Check treeLock
  if (!($('#treebtn', parent.document).css('display') == 'none')) {
    top.document.activeElement.blur();
    setTimeout(function () {
      // Prevent the tree from staying open
      top.treebtn.hide_treemenu();
    }, 300);
  }
}

var treeBtnSize = $('#treebtn', parent.document).css('width');
function change_treeMenuLock() {
  // get element
  var treeBtn  = $('#treebtn', parent.document);
  var mainFrm  = $('#mainfrmarea', parent.document);
  var mainFnc  = $('#mainfunc_area', parent.document);
  var statFrm  = $('#statbar', parent.document);
  var keySheet = $('#tpkeyssheet', parent.document);
  var treeFrm  = $('#treemod', parent.document);
  var pnlArea  = $('#pnlarea', parent.document);
  var lockBtn  = $('#treeLockBtn');

  statbar_w = statFrm.width();

  if (treeBtn.css('display') == 'none') {
    // Unlock tree menu
    treeBtn.css('display', 'block');
    treeBtn.css('width', treeBtnSize);
    treebtn_w = treeBtn.width();
    statFrm.css('width', statbar_w - treebtn_w);
    setTreePos();
    window.parent.tree_resize();
    // Fix main frame area
    mainFrm.css({ "width": "100%", "position": '' });
    mainFnc.css({ "position": '' });
    keySheet.css({ "position": '', "right": '' });
    // Fix pnlarea
    pnlArea.css({ "width": '' });

    // Change treemenu icon
    lockBtn.css('background-image', 'url("unlock.png")');
    top.treemod.focus();

  } else {
    // Lock tree menu
    treebtn_w = treeBtn[0].scrollWidth;
    treeBtn.css('display', 'none');
    treeBtn.css('width', 0);
    statFrm.css('width', treebtn_w + statbar_w);
    // Resize tree menu
    treeFrm.css('height', top.h_mainfrm + "px");
    setTreePos();
    var w_treemod = treeFrm.outerWidth();
    treeFrm.contents().find('#treeScara').css({ 'max-height': top.h_mainfrm - $('#treeHead').height() - $('#treeBottom').height() + 'px' });
    mainFrm.css({ "position" : 'relative', "left" : w_treemod + 'px' });
    // Fix main frame area
    if (((top.is_key_open) && (top.is_vtcl_disp)) || !(top.keys_vis)) {
      keySheet.css({"position": '', "right": ''});
    }
    // for horizontal display
    if(!(top.is_vtcl_disp)){
      if(top.keysheetLR.main == "right"){
        mainFnc.css({ "position": 'relative', "right": w_treemod });
      } else {
        keySheet.css({ "position": 'relative', "right": w_treemod });
      }
    }
    // Fix pnlarea
    pnlArea.css({ "width": 'calc(100% - 238px)' });

    // Change treemenu icon
    lockBtn.css('background-image', 'url("lock.png")');
  }

  top.setDispCSS("#tpkeyssheet", "width");
  top.setDispCSS("#mainfunc_area", "width");
  if (navigator.userAgent.indexOf("iPad") > 0) {
    top.setDispCSS("#container", "width", "#mainfrm");
  }
  top.setDispCSS("#prim", "width", "#mainfrm");
  top.setDispCSS("#mainfrm", "width");
  top.setDispCSS("#funckeys", "width");
  top.setDispCSS("#tpkeys", "width");
  top.setDispCSS("#primstat", "width", "#mainfrm");
  if ((window.ontouchstart !== undefined) && (top.is_key_open) && (top.is_vtcl_disp) && (top.keys_vis) && (typeof top.document.getElementById("tpkeyssheet").contentWindow.g_resizeKSfunc === "function")) {
    top.document.getElementById("tpkeyssheet").contentWindow.g_resizeKSfunc();
  }
  // Fix home
  top.resizeHomeProc();
  top.w_tree = top.setTreeWidth();
  top.mainfrm.iframe_size();
  return;
}

// FSI 20190919 for get menu mode base or custom
function get_menuMode() {
  return currentMenu;
}

// FSI 20190919 for change menu base or custom
function tree_changeMenu(menuType) {
  // save current menu mode
  currentMenu = menuType;

  var crntTreetype = ((currentMenu == MENU_BASE) ? TYPE_BASE_TREE : TYPE_CUSTOM_TREE);

  $.getJSON('/softpart/xmljson?file=/frh/irprog.xml&id=' + crntTreetype + '&connect_id=' + top.g_connect_id, function (json) {
    if (json != undefined) {
      var node = null;
      var treeEle = document.getElementById("treeScara");
      treeEle.config.onclick = nodeOnClick;
      // Call refresh with URL so it is selected
      treeEle.refresh(json, primScreenId, false);

      if (primScreenId != '') {
        node = treeEle.getSelectedNode();
      }
      if (node) {
        // Open all the parent nodes, and click the selected menu
        treeEle.openNodeAncestor(node);
      }

      calcMargin();
      if (!($('#treebtn', parent.document).css('display') == 'none')) {
        window.parent.tree_resize();
      }
    }
  });
}

function setTreePos(){
  var treeFrm  = $('#treemod', parent.document);
  var homeFrm  = $('#home', parent.document);
  if($('#treebtn', parent.document).css('display') == 'none'){
    treeFrm.css({ "margin": "0px", "width":"238px" });
    top.treemodMargin  = 5;
  } else if(homeFrm.css('z-index') > 0){
    // for home frame
    treeFrm.css({ "margin": "5px 0px 0px 5px", "width":"270px" });
    top.treemodMargin = 5;

  } else {
    // for main frame
    treeFrm.css({ "margin": "45px 0px 0px 5px", "width":"270px" });
    top.treemodMargin  = 50;
  }
}

// Search maximum number of sections and calc margin size.
function calcMargin(){
  var treeEle = top.treemod.document.getElementById("treeScara");
  var maxSectionNum = cntMaxHierarchy(treeEle.childNodes);
  var marginMaxW = (treeEle.offsetWidth / 6);
  var marginSize = marginMaxW / (maxSectionNum + 1);

  // Set margin-left
  $('#treemod', parent.document).contents().find('.tree-select li').css({
    'margin-left': marginSize + 'px'
  });
  // for firstChild(top section node)
  $('#treemod', parent.document).contents().find('.tree-select > ul > li').css({
    'margin-left': '0px'
  });

  function cntMaxHierarchy(topNode) {
    var curLpSecCnt = 0;
    var maxSecCnt = 0;
    searchSectionIcon(topNode);
    return maxSecCnt;

    function searchSectionIcon(childNode){
      for(var i = 0; i < childNode.length; i++){
        var childLi = childNode[i].getElementsByTagName('li');
        if(childLi.length > 0){
          searchSectionIcon(childLi);
        } else {
          curLpSecCnt = 0;
          cntSection(childNode[childNode.length-1]);
          if(maxSecCnt < curLpSecCnt) {
            maxSecCnt = curLpSecCnt;
          }
        }
      }
    }

    function cntSection(parentLi) {
      if(parentLi.id != 'treeScara'){
        var parentA = parentLi.getElementsByTagName('a')[0].childNodes[0];
        if(parentA.classList.contains('tree-select-arrow')) {
          curLpSecCnt++;
        }
        cntSection(parentLi.parentNode.parentNode);
      }
    }
  }
}

// Hide treeLockBtn, treeHomeBtn, treeCstmBtn, treeChgBtn
function hideTreeBtns(){
  $('#treeHead').css('display', 'none');
  $('#treeBottom').css('display', 'none');
  // Shift the tree up.
  $('#treeScara').css('top', '0');
}

var mninst = {

  MAX_IPL_SCRN: 30, // Maximum number of system variables
  xmlCBFunc   : null, // return true or false to this function
  xmlCstmFunc : null, // main processing after get xml

  SUCCESS_UPD  : 0, // Successfully updated system variables
  ERR_GET_MENU : 123111, // Failed to get PLMENU.XML
  ERR_PRS_MENU : 123112, // Failed to parse PLMENU.XML
  ERR_GET_SCRN : 123113, // Failed to get IPL_SCRN
  ERR_FULL_SLOT: 123101, // Out of free slots in IPL_SCRN
  ERR_SET_SCRN : 123114, // Failed to set IPL_SCRN

  // Set Screen ID to empty slot at IPL_SCRN
  addMenuData: function (filepath, callback) {
    mninst.xmlCBFunc     = callback;
    mninst.xmlCstmFunc   = mninst.getIPLScrnSCB;
    // get additional xml
    mninst.getXMLMenuData(filepath[0].slice(0, -6) + "eg.xml");
  },

  // Delete Screen ID at IPL_SCRN
  delMenuData: function (filepath, callback) {
    mninst.xmlCBFunc     = callback;
    mninst.xmlCstmFunc   = mninst.getIPLScrnDCB;
    // get additional xml
    mninst.getXMLMenuData(filepath[0].slice(0, -6) + "eg.xml");
  },

  // Get menu data in xml format
  getXMLMenuData: function (path) {
    $.ajax({
      beforeSend: function (xhr) {
        xhr.overrideMimeType('text/html;charset=UTF-8');
      },
      type: "GET",
      url: path,
      dataType: "xml",
      cache: false,

    }).done(function (xml_data) {
      mninst.getIPLScrn(xml_data);

    }).fail(function (xmlhttprequest, textstatus, errorthrown) {
      console.log(xmlhttprequest);
      console.log(textstatus);
      console.log(errorthrown);
      mninst.xmlCBFunc(mninst.ERR_GET_MENU);
    });
  },

  // Get Screen ID to menu data and make CVR
  getIPLScrn: function (xml_data) {

    try {
      var scrnIDList = mninst.getAddURL(xml_data);
    } catch (e) {
      console.log(e); // Syntax error
      mninst.xmlCBFunc(mninst.ERR_PRS_MENU);
      return;
    }

    var sysnum_xml = '<?xml version="1.0" encoding="UTF-8"?>\r'
      + '<XMLCFG>\r<PROG name="*SYSTEM*">\r<VAR name="$IPL_SCRN" />\r'
      + '</PROG>\r</XMLCFG>';

    // Create Blob CVR
    var file_cvr = new Blob([sysnum_xml], { type: "text/plain" });
    top.getXHR("iplscrn.cvr", file_cvr, mninst.convIPLStr, scrnIDList); // irprog_io

  },

  // Analyze data after convert XVR CallBack
  convIPLStr: function (status, getText, setIDList) {

    if (status != top.IO_SUCCESS) {
      console.log("getXHR error");
      mninst.xmlCBFunc(mninst.ERR_GET_SCRN);
      return;
    }

    var scrnIDList = getText.match(/"RW">.*?<\/ARRAY>/g);
    for (var i = 0; i < scrnIDList.length; i++) { // for iOS
      scrnIDList[i] = scrnIDList[i].substring(5, scrnIDList[i].length - 8);
    }

    mninst.xmlCstmFunc(setIDList, scrnIDList);
  },

  // Set ID of install menu to IPL_SCRN
  getIPLScrnSCB: function (newID, baseID) {

    // If we cannot get the required number of empty slots, a failure is returned.
    if (!mninst.isEnoughslots(newID, baseID)) {
      console.log("Not enough slots error");
      mninst.xmlCBFunc(mninst.ERR_FULL_SLOT);
      return;
    }

    // Search empty slot in $IPL_SCRN and set new screen ID
    for (var i = 0; i < newID.length; i++) {
      var ind = baseID.indexOf("********");
      if ((ind == -1) || (baseID.indexOf(newID[i]) > -1)) { continue; }
      baseID[ind] = newID[i];
    }

    // Set Screen ID to empty slot actually
    mninst.makeIPLScrnXHR(baseID);
  },

  // Delete ID of uninstall menu in IPL_SCRN (set empty)
  getIPLScrnDCB: function (delID, baseID) {

    for (var i = 0; i < delID.length; i++) {
      var ind = baseID.indexOf(delID[i]);
      if (ind != -1) { baseID[ind] = ""; }
    }

    // Set an empty ID to the slot where the ID to be deleted is registered
    mninst.makeIPLScrnXHR(baseID);
  },

  // check empty slots quantity
  isEnoughslots: function (newID, baseID) {

    var empList = baseID.filter(function (x) { return x.trim() == "********"; });
    var dupList = newID.filter(function (x) { return baseID.indexOf(x) > -1; });

    // If we cannot get the required number of empty slots
    // or all screens are more than 30, a failure is returned.
    if ((empList.length < newID.length - dupList.length) ||
        (newID.length > mninst.MAX_IPL_SCRN)) {
      return false;
    }

    return true;
  },

  // make XHR file and post it
  makeIPLScrnXHR: function (array) {

    // Create CVR
    var file_xvr = mninst.createUTF8Blob(mninst.makeIPLScrnStr(array));
    top.postXHR("iplscrn.xvr", file_xvr, mninst.postSysXHRCB);

    var reader = new FileReader();
    reader.addEventListener("loadend", function () {});
    reader.readAsArrayBuffer(file_xvr);

  },

  // make XHR string
  makeIPLScrnStr: function (array) {
    var iplXml = "";

    iplXml += '<?xml version="1.0" encoding="UTF-8"?>\r' + '<XMLVAR>\r';
    iplXml += ' <PROG name="*SYSTEM*">\r' + '  <VAR name="$IPL_SCRN">\r';

    for (var i = 0; i < array.length; i++) {
      if (array[i] == "********") { continue; } // Avoid VARS-217
      var forceAttr = ((array[i] == "") ? ' force ="TRUE"' : ''); // init flag
      var setSysVal = ((array[i] == "") ? "********" : array[i]);
      iplXml += '   <ARRAY name="$IPL_SCRN[' + (i + 1) + ']" prot ="RW"' + forceAttr + '>' + setSysVal + '</ARRAY>\r';
    }

    iplXml += '  </VAR>\r' + ' </PROG>\r' + '</XMLVAR>';

    return iplXml;
  },

  // Returns to Callback if XHR post completed successfully
  postSysXHRCB: function (status) {
    if (status == top.IO_SUCCESS) {
      mninst.xmlCBFunc(mninst.SUCCESS_UPD); // Processing Exit

    } else {
      console.log("Set system variable failed");
      mninst.xmlCBFunc(mninst.ERR_SET_SCRN);
    }
  },

  // Make url array from the installed xml
  extractURL: function (str) {
    var strElem = str;
    var returnArr = [];

    for (var j = 0; j < strElem.length; j++) {

      if ((strElem[j].getAttributeNode("Screen") != null) && // node
        (strElem[j].children.length == 0)) {
        var nodeURL = strElem[j].getAttributeNode("Screen").value;
        returnArr.push(nodeURL);

      } else if (strElem[j].children.length > 0) { // section
        var data    = strElem[j].children;
        var nodeURL = mninst.extractURL(data);
        returnArr   = returnArr.concat(nodeURL);

      }
    }
    return returnArr;
  },

  // Get url (Screen ID) of additional menu
  getAddURL: function (xml_data) {
    var extractURLArr = [];
    var returnURL     = [];
    var joinArr   = xml_data.getElementsByTagName("FanucMenu")[0].children;
    extractURLArr = extractURLArr.concat(mninst.extractURL(joinArr));

    //Remove duplicate Screen ID
    returnURL = extractURLArr.filter(function (x, i, self) {
      return self.indexOf(x) === i;
    });

    return returnURL;
  },

  // Create BLOB data by english(UTF-8)
  createUTF8Blob: function (str) {
    var blob;
    var codeArr = [];
    for (var i = 0; i < str.length; i++) {
      codeArr.push(str.charCodeAt(i));
    }
    var sendData = codeArr;
    var encArr = '';
    // Increase branching when supporting different languages.
    encArr = top.Encoding.convert(codeArr, 'UTF-8', 'UNICODE');
    sendData = new Uint8Array(encArr);

    blob = new Blob([sendData], { type: 'text/plain;' });
    return blob;
  },

  // update tree menu display (No change in menu XML)
  updateTreeMenu: function () {
    tree_changeMenu(get_menuMode());
  }

};

// Search for the menu on the displayed screen.
function findSelectNode(root, elem){
  var tagName = elem.tagName;
  var candidates = root.getElementsByTagName(tagName.toUpperCase());
  var selected = [];
  for (var i = 0, len = candidates.length; i < len; i++) {
    if ((candidates[i].innerText == elem.innerText)
      && (candidates[i].parentElement.id == elem.parentElement.id)) {
      selected.push(candidates[i]);
    }
  }
  return selected;
}
